% fcst_psiNX_mean_V1.m
% 
% Forecast psiNX shares using cosine transformations ... 
%       Linear trend + I(1) model
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function fcst_psiNX_mean_V1

% -- File Directories -- %
% datadir = 'Data/DataReplication/DataFinal/'; 
% outdir = 'Tables/';
% figdir = 'Figures/';
matdir = 'Output/';

% -- Load Data and Setup -- %
load_data;
% n_draws = 5000;
period_lower = 20;       % Shortest Period 
T_is = size(theta,1);
q_is = floor(2*T/period_lower);
per_q_is = 2*T/q_is;
fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
fprintf('Number of Shortest Periods: %5.1f \n',per_q_is);

Y = psiNX;
% Get some results from I_1 model
I_1 = 1;
I_trend = 1; % Include linear trend in the projections
h_os = T_is;
[Yproj_is, Yproj_os_mean, trend_os_only] = fcst_y_trend_mean(Y,q_is,h_os,I_1,I_trend);
T_os = size(Yproj_is,1);

% Get 
Y_is = [Y;NaN(T_os-T_is,size(Y,2))];

% Add the trend-only Forecast
Y_os_trend = NaN(size(Yproj_os_mean));
Y_os_trend(T_is+1:end,:) = Yproj_os_mean(T_is,:)+trend_os_only(T_is+1:end,:)-trend_os_only(T_is,:);

% Save the results
save_variables = {'Y_is','Yproj_os_mean','Yproj_is','Y_os_trend','trend_os_only'};
save([matdir 'fcst_psiNX_V1_' num2str(q_is) '.mat'],save_variables{:});
